/****** Object:  StoredProcedure [dbo].[AccountIsUsed]    Script Date: 01/17/2024 14:08:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Azimi
-- Create date: 2022/6/5
-- Description:	Check if ACCOUNT IS USED
-- =============================================
ALTER PROCEDURE [dbo].[AccountIsUsed]
	@TotalID bigint = 0, 
	@ControlID bigint = 0, 
	@DetailID1 bigint = 0, 
	@DetailID2 bigint = 0,
	@ForRelation bit = 0,
	@Full bit = 1
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @NUM as bigint
	DECLARE @N as int
	DECLARE @Flags as bigint
	SET @NUM = 0
	SET @Flags=0

	if @Full = 1
	BEGIN
		select @N=Count(*) from [dbo].[AccChequeIn] WITH(NOLOCK) 
			where ((@TotalID=0 OR DebitTotalID=@TotalID) AND (@ControlID=0 OR DebitControlID=@ControlID) AND DebitDetailID1=@DetailID1 AND DebitDetailID2=@DetailID2)
				OR ((@TotalID=0 OR CreditTotalID=@TotalID) AND CreditControlID=@ControlID AND CreditDetailID1=@DetailID1 AND CreditDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR OwnerTotalID=@TotalID) AND OwnerControlID=@ControlID AND OwnerDetailID1=@DetailID1 AND OwnerDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccChequeIn - ' + Str(@N)
			SET @Flags=@Flags+1
			SET @NUM = @NUM + @N 
		END
		
		select @N=Count(*) from [dbo].[AccChequeInCredit] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccChequeInCredit - ' + Str(@N)
			SET @Flags=@Flags+2
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccChequeInfo] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccChequeInfo - ' + Str(@N)
			SET @Flags=@Flags+4
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccChequeInOwner] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccChequeInOwner - ' + Str(@N)
			SET @Flags=@Flags+8
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccChequeOut] WITH(NOLOCK) 
			where ((@TotalID=0 OR DebitTotalID=@TotalID) AND (@ControlID=0 OR DebitControlID=@ControlID) AND DebitDetailID1=@DetailID1 AND DebitDetailID2=@DetailID2)
				OR ((@TotalID=0 OR CreditTotalID=@TotalID) AND (@ControlID=0 OR CreditControlID=@ControlID) AND CreditDetailID1=@DetailID1 AND CreditDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccChequeOut - ' + Str(@N)
			SET @Flags=@Flags+16
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccChequeOutDebit]  WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccChequeOutDebit - ' + Str(@N)
			SET @Flags=@Flags+32
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccChequeOutItemInfo] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccChequeOutItemInfo - ' + Str(@N)
			SET @Flags=@Flags+64
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccDocItem] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccDocItem - ' + Str(@N)
			SET @Flags=@Flags+128
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccFactor] WITH(NOLOCK) 
			where ((@TotalID=0 OR PersonTotalID=@TotalID) AND (@ControlID=0 OR PersonControlID=@ControlID) AND PersonDetailID1=@DetailID1 AND PersonDetailID2=@DetailID2)
				OR ((@TotalID=0 OR DiscontTotalID=@TotalID) AND (@ControlID=0 OR DiscontControlID=@ControlID) AND DiscontDetailID1=@DetailID1 AND DiscontDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR AvarezTotalID=@TotalID) AND (@ControlID=0 OR AvarezControlID=@ControlID) AND AvarezDetailID1=@DetailID1 AND AvarezDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR HamlTotalID=@TotalID) AND (@ControlID=0 OR HamlControlID=@ControlID) AND HamlDetailID1=@DetailID1 AND HamlDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR VizitorTotalID=@TotalID) AND (@ControlID=0 OR VizitorControlID=@ControlID) AND VizitorDetailID1=@DetailID1 AND VizitorDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccFactor - ' + Str(@N)
			SET @Flags=@Flags+256
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccFactorDetail] WITH(NOLOCK) 
			where ((@TotalID=0 OR OrderTotalID=@TotalID) AND (@ControlID=0 OR OrderControlID=@ControlID) AND OrderDetailID1=@DetailID1 AND OrderDetailID2=@DetailID2)
				OR ((@TotalID=0 OR OtherTotalID=@TotalID) AND (@ControlID=0 OR OtherControlID=@ControlID) AND OtherDetailID1=@DetailID1 AND OtherDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccFactorDetail - ' + Str(@N)
			SET @Flags=@Flags+512
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccSellFactor] WITH(NOLOCK) 
			where ((@TotalID=0 OR OrderTotalID=@TotalID) AND (@ControlID=0 OR OrderControlID=@ControlID) AND OrderDetailID1=@DetailID1 AND OrderDetailID2=@DetailID2)
				OR ((@TotalID=0 OR BuyerTotalID=@TotalID) AND (@ControlID=0 OR BuyerControlID=@ControlID) AND BuyerDetailID1=@DetailID1 AND BuyerDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR SellerTotalID=@TotalID) AND (@ControlID=0 OR SellerControlID=@ControlID) AND SellerDetailID1=@DetailID1 AND SellerDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccSellFactor - ' + Str(@N)
			SET @Flags=@Flags+1024
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccSellFactorShip] WITH(NOLOCK) 
			where ((@TotalID=0 OR KalaTotalID=@TotalID) AND (@ControlID=0 OR kalaControlID=@ControlID) AND KalaDetailID1=@DetailID1 AND KalaDetailID2=@DetailID2)
		if @N > 0
		BEGIN
			print 'AccSellFactorShip - ' + Str(@N)
			SET @Flags=@Flags+2048
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccSellFactorTrucks] WITH(NOLOCK) 
			where  ((@TotalID=0 OR ChaperTotalID=@TotalID) AND (@ControlID=0 OR ChaperControlID=@ControlID) AND ChaperDetailID1=@DetailID1 AND ChaperDetailID2=@DetailID2)
				OR ((@TotalID=0 OR HamlTotalID=@TotalID) AND (@ControlID=0 OR HamlControlID=@ControlID) AND HamlDetailID1=@DetailID1 AND HamlDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccSellFactorTrucks - ' + Str(@N)
			SET @Flags=@Flags+4096
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccWarehouse] WITH(NOLOCK) 
			where ((@TotalID=0 OR PersonTotalID=@TotalID) AND (@ControlID=0 OR PersonControlID=@ControlID) AND PersonDetailID1=@DetailID1 AND PersonDetailID2=@DetailID2)
		if @N > 0
		BEGIN
			print 'AccWarehouse - ' + Str(@N)
			SET @Flags=@Flags+8192
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccWarehouseDetails] WITH(NOLOCK) 
			where ((@TotalID=0 OR OrderTotalID=@TotalID) AND (@ControlID=0 OR OrderControlID=@ControlID) AND OrderDetailID1=@DetailID1 AND OrderDetailID2=@DetailID2)
				OR ((@TotalID=0 OR OtherTotalID=@TotalID) AND (@ControlID=0 OR OtherControlID=@ControlID) AND OtherDetailID1=@DetailID1 AND OtherDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'AccWarehouseDetails - ' + Str(@N)
			SET @Flags=@Flags+16384
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccWarehouseInfo] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccWarehouseInfo - ' + Str(@N)
			SET @Flags=@Flags+32768
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[AccWareProductTree] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
				OR (@TotalID=0 OR MainTotalID=@TotalID) AND (@ControlID=0 OR MainControlID=@ControlID) AND MainDetailID1=@DetailID1 AND MainDetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'AccWareProductTree - ' + Str(@N)
			SET @Flags=@Flags+65536
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[Chicken] WITH(NOLOCK) 
			where ((@TotalID=0 OR OrderTotalID=@TotalID) AND (@ControlID=0 OR OrderControlID=@ControlID) AND OrderDetailID1=@DetailID1 AND OrderDetailID2=@DetailID2)
				OR ((@TotalID=0 OR BuyerTotalID=@TotalID) AND (@ControlID=0 OR BuyerControlID=@ControlID) AND BuyerDetailID1=@DetailID1 AND BuyerDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR SellerTotalID=@TotalID) AND (@ControlID=0 OR SellerControlID=@ControlID) AND SellerDetailID1=@DetailID1 AND SellerDetailID2=@DetailID2) 
				OR ((@TotalID=0 OR TruckTotalID=@TotalID) AND (@ControlID=0 OR TruckControlID=@ControlID) AND TruckDetailID1=@DetailID1 AND TruckDetailID2=@DetailID2) 
		if @N > 0
		BEGIN
			print 'Chicken - ' + Str(@N)
			SET @Flags=@Flags+131072
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[POSDetail] WITH(NOLOCK) 
			where (@TotalID=0 OR OrderTotalID=@TotalID) AND (@ControlID=0 OR OrderControlID=@ControlID) AND OrderDetailID1=@DetailID1 AND OrderDetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'POSDetail - ' + Str(@N)
			SET @Flags=@Flags+262144
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[POSMain] WITH(NOLOCK) 
			where (@TotalID=0 OR PersonTotalID=@TotalID) AND (@ControlID=0 OR PersonControlID=@ControlID) AND PersonDetailID1=@DetailID1 AND PersonDetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'POSMain - ' + Str(@N)
			SET @Flags=@Flags+524288
			SET @NUM = @NUM + @N 
		END

		select @N=Count(*) from [dbo].[WareCount] WITH(NOLOCK) 
			where (@TotalID=0 OR TotalID=@TotalID) AND (@ControlID=0 OR ControlID=@ControlID) and DetailID1=@DetailID1 and DetailID2=@DetailID2
		if @N > 0
		BEGIN
			print 'WareCount - ' + Str(@N)
			SET @Flags=@Flags+1048576
			SET @NUM = @NUM + @N 
		END

		IF @ForRelation=0 
		BEGIN 
			IF @DetailID1 > 0
			BEGIN
				select @N=Count(*) from [dbo].[AccDetailDetail]  WITH(NOLOCK) where DetailID1=@DetailID1 
				if @N > 0
				BEGIN
					print 'AccDetailDetail - ' + Str(@N)
					SET @Flags=@Flags+2097152
					SET @NUM = @NUM + @N 
				END
			END
			ELSE 
			IF @ControlID > 0
			BEGIN
				select @N=Count(*) from [dbo].[AccControlDetail] WITH(NOLOCK) where @ForRelation=0 and DetailID=@ControlID 
				if @N > 0
				BEGIN
					print 'AccControlDetail - ' + Str(@N)
					SET @Flags=@Flags+4194304
					SET @NUM = @NUM + @N 
				END
			END
			ELSE
			IF @TotalID > 0
			BEGIN
				select @N=Count(*) from [dbo].[AccTotalControl] WITH(NOLOCK) where @ForRelation=0 and TotalID=@ControlID 
				if @N > 0
				BEGIN
					print 'AccTotalControl - ' + Str(@N)
					SET @Flags=@Flags+8388608
					SET @NUM = @NUM + @N 
				END
			END
		END
	END
	ELSE
	BEGIN
		IF @DetailID2 > 0
		BEGIN
			Select @Num = Sum(Num), @Flags = @Flags + Sum(flags) from (
				select Count(*) as NUM, Count(*)*1 as flags from [dbo].[AccChequeIn] WITH(NOLOCK) where DebitDetailID2=@DetailID2 or CreditDetailID2=@DetailID2 or OwnerDetailID2 =@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2 as flags from [dbo].[AccChequeInCredit] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2 as flags from [dbo].[AccChequeInfo] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2 as flags from [dbo].[AccChequeInOwner] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2 as flags from [dbo].[AccChequeOut] WITH(NOLOCK) where DebitDetailID2=@DetailID2 or CreditDetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2 as flags from [dbo].[AccChequeOutDebit] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2 as flags from [dbo].[AccChequeOutItemInfo] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2 as flags from [dbo].[AccDocItem] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2 as flags from [dbo].[AccFactor] WITH(NOLOCK) where PersonDetailID2=@DetailID2 or DiscontDetailID2=@DetailID2 or AvarezDetailID2=@DetailID2 or HamlDetailID2=@DetailID2 or VizitorDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactorDetail] WITH(NOLOCK) where OrderDetailID2=@DetailID2 or OtherDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactor] WITH(NOLOCK) where OrderDetailID2=@DetailID2 or BuyerDetailID2=@DetailID2 or SellerDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorShip] WITH(NOLOCK) where KalaDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorTrucks] WITH(NOLOCK) where ChaperDetailID2=@DetailID2 OR ChaperDetailID2 =@DetailID2 OR HamlDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouse] WITH(NOLOCK) where PersonDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseDetails] WITH(NOLOCK) where OrderDetailID2=@DetailID2 OR OtherDetailID2 =@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseInfo] WITH(NOLOCK) where DetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWareProductTree] WITH(NOLOCK) where DetailID2=@DetailID2
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[Chicken] WITH(NOLOCK) where BuyerDetailID2=@DetailID2 OR OrderDetailID2=@DetailID2 OR SellerDetailID2=@DetailID2 OR TruckDetailID2 =@DetailID2   
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSDetail] WITH(NOLOCK) where OrderDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSMain] WITH(NOLOCK) where PersonDetailID2=@DetailID2 
				UNION
				select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[WareCount] WITH(NOLOCK) where DetailID2=@DetailID2 
			) t
		END
		ELSE
			IF @DetailID1 > 0
			BEGIN
				Select @Num = @Num + Sum(Num), @Flags = @Flags + Sum(flags) from (
					select Count(*) as NUM, Count(*)*1 as flags from [dbo].[AccChequeIn] WITH(NOLOCK) where DebitDetailID1=@DetailID1 or CreditDetailID1=@DetailID1 or OwnerDetailID1 =@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2 as flags from [dbo].[AccChequeInCredit] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2 as flags from [dbo].[AccChequeInfo] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2 as flags from [dbo].[AccChequeInOwner] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2 as flags from [dbo].[AccChequeOut] WITH(NOLOCK) where DebitDetailID1=@DetailID1 or CreditDetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2 as flags from [dbo].[AccChequeOutDebit] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2 as flags from [dbo].[AccChequeOutItemInfo] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2 as flags from [dbo].[AccDocItem] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactor] WITH(NOLOCK) where PersonDetailID1=@DetailID1 or DiscontDetailID1=@DetailID1 or AvarezDetailID1=@DetailID1 or HamlDetailID1=@DetailID1 or VizitorDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactorDetail] WITH(NOLOCK) where OrderDetailID1=@DetailID1 or OtherDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactor] WITH(NOLOCK) where OrderDetailID1=@DetailID1 or BuyerDetailID1=@DetailID1 or SellerDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorShip] WITH(NOLOCK) where KalaDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorTrucks] WITH(NOLOCK) where ChaperDetailID1=@DetailID1 OR ChaperDetailID1 =@DetailID1 OR HamlDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouse] WITH(NOLOCK) where PersonDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseDetails] WITH(NOLOCK) where OrderDetailID1=@DetailID1 OR OtherDetailID1 =@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseInfo] WITH(NOLOCK) where DetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWareProductTree] WITH(NOLOCK) where DetailID1=@DetailID1
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[Chicken] WITH(NOLOCK) where BuyerDetailID1=@DetailID1 OR OrderDetailID1=@DetailID1 OR SellerDetailID1=@DetailID1 OR TruckDetailID1 =@DetailID1   
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSDetail] WITH(NOLOCK) where OrderDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSMain] WITH(NOLOCK) where PersonDetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[WareCount] WITH(NOLOCK) where DetailID1=@DetailID1 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccDetailDetail]  WITH(NOLOCK) where @ForRelation=0 and DetailID1=@DetailID1 
				) t
			END
		ELSE 
			IF @ControlID > 0
			BEGIN
			print 'x'
				Select @Num = @Num + Sum(Num), @Flags = @Flags + Sum(flags) from (
					select Count(*) as NUM, Count(*)*1 as flags from [dbo].[AccChequeIn] WITH(NOLOCK) where DebitControlID=@ControlID or CreditControlID=@ControlID or OwnerControlID =@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2 as flags from [dbo].[AccChequeInCredit] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2 as flags from [dbo].[AccChequeInfo] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2 as flags from [dbo].[AccChequeInOwner] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2 as flags from [dbo].[AccChequeOut] WITH(NOLOCK) where DebitControlID=@ControlID or CreditControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2 as flags from [dbo].[AccChequeOutDebit] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2 as flags from [dbo].[AccChequeOutItemInfo] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2 as flags from [dbo].[AccDocItem] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactor] WITH(NOLOCK) where PersonControlID=@ControlID or DiscontControlID=@ControlID or AvarezControlID=@ControlID or HamlControlID=@ControlID or VizitorControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactorDetail] WITH(NOLOCK) where OrderControlID=@ControlID or OtherControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactor] WITH(NOLOCK) where OrderControlID=@ControlID or BuyerControlID=@ControlID or SellerControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorShip] WITH(NOLOCK) where KalaControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorTrucks] WITH(NOLOCK) where ChaperControlID=@ControlID OR ChaperControlID =@ControlID OR HamlControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouse] WITH(NOLOCK) where PersonControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseDetails] WITH(NOLOCK) where OrderControlID=@ControlID OR OtherControlID =@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseInfo] WITH(NOLOCK) where ControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWareProductTree] WITH(NOLOCK) where ControlID=@ControlID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[Chicken] WITH(NOLOCK) where BuyerControlID=@ControlID OR OrderControlID=@ControlID OR SellerControlID=@ControlID OR TruckControlID =@ControlID   
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSDetail] WITH(NOLOCK) where OrderControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSMain] WITH(NOLOCK) where PersonControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[WareCount] WITH(NOLOCK) where ControlID=@ControlID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccControlDetail] WITH(NOLOCK) where @ForRelation=0 and ControlID=@ControlID 
				) t
			END
		ELSE
			IF @TotalID > 0
			BEGIN
				Select @Num = @Num + Sum(Num), @Flags = @Flags + Sum(flags) from (
					select Count(*) as NUM, Count(*)*1 as flags from [dbo].[AccChequeIn] WITH(NOLOCK) where DebitTotalID=@TotalID or CreditTotalID=@TotalID or OwnerTotalID =@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2 as flags from [dbo].[AccChequeInCredit] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2 as flags from [dbo].[AccChequeInfo] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2 as flags from [dbo].[AccChequeInOwner] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2 as flags from [dbo].[AccChequeOut] WITH(NOLOCK) where DebitTotalID=@TotalID or CreditTotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2 as flags from [dbo].[AccChequeOutDebit] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2 as flags from [dbo].[AccChequeOutItemInfo] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2 as flags from [dbo].[AccDocItem] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactor] WITH(NOLOCK) where PersonTotalID=@TotalID or DiscontTotalID=@TotalID or AvarezTotalID=@TotalID or HamlTotalID=@TotalID or VizitorTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccFactorDetail] WITH(NOLOCK) where OrderTotalID=@TotalID or OtherTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactor] WITH(NOLOCK) where OrderTotalID=@TotalID or BuyerTotalID=@TotalID or SellerTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorShip] WITH(NOLOCK) where KalaTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccSellFactorTrucks] WITH(NOLOCK) where ChaperTotalID=@TotalID OR ChaperTotalID =@TotalID OR HamlTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouse] WITH(NOLOCK) where PersonTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseDetails] WITH(NOLOCK) where OrderTotalID=@TotalID OR OtherTotalID =@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWarehouseInfo] WITH(NOLOCK) where TotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccWareProductTree] WITH(NOLOCK) where TotalID=@TotalID
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[Chicken] WITH(NOLOCK) where BuyerTotalID=@TotalID OR OrderTotalID=@TotalID OR SellerTotalID=@TotalID OR TruckTotalID =@TotalID   
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSDetail] WITH(NOLOCK) where OrderTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[POSMain] WITH(NOLOCK) where PersonTotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[WareCount] WITH(NOLOCK) where TotalID=@TotalID 
					UNION
					select Count(*) as NUM, Count(*)*1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2 as flags from [dbo].[AccTotalControl] WITH(NOLOCK) where @ForRelation=0 and TotalID=@TotalID  
				) t
			END
	END
	--select(1*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2*2)
	select @Num*100000000+@Flags 
END